﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Transactions;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.DAL;

namespace AZVIC.Ei8htPOS.BAL
{
    [DataObjectAttribute()]
    public static class ProductBrandBL
    {
        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static ProductBrand GetItem(Guid productBrandID, string keyword)
        {
            return ProductBrandDB.GetItem(productBrandID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static List<ProductBrand> GetList(Guid productBrandID, string keyword)
        {
            return ProductBrandDB.GetList(productBrandID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataTable GetDataTable(Guid productBrandID, string keyword)
        {
            return ProductBrandDB.GetDataTable(productBrandID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataSet GetDataSet(Guid productBrandID, string keyword)
        {
            return ProductBrandDB.GetDataSet(productBrandID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Update, true)]
        public static bool Save(ProductBrand myProductBrand)
        {
            using (TransactionScope myTransactionScope = new TransactionScope())
            {
                ProductBrandDB.Save(myProductBrand);

                myTransactionScope.Complete();
                return true;
            }
        }
    }
}
